import sys
sys.path = ['C:/Users/Administrator/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path

from suds.client import Client
import datetime
from pytz import timezone
from pytz import common_timezones
import pytz
import time
from ReplaceDatabase import ReplaceDatabase
from time import sleep

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'GEORGIA'
state_short = 'GA'
domain = 'GA.VA.GOV'
facility1_site_id = '556'
facility2_abbr = 'GVARMC'
facility3_abbr = 'GVAOPC'

PatientSSN = '100000000'
patientLName = 'ROBERSON'
PatientFullName='ROBERSON,RAMIRO'
SeactionName = 'PRIMARY CARE'
AppointmentTypeCat = 'REGULAR'
ProviderResource = 'case1 step 9 test'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase5Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase5/cache.dat")
sleep(60)

print 'setp 1 Select Patient'
PatientName = client.service.SearchPatients(facility1_site_id,PatientSSN)
print PatientName

for p in PatientName.PatientSearchResult:
	if p.LastName == patientLName:
		PatientN = p
		break;

print 'Step 2 Display Demographics' +'\n'
pat = client.service.GetPatient(PatientN)
print pat

print 'Step 3 Walkin Appt' + '\n'
facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)

for p in facilities.Facility:
	if p.Name == facility3:
		facility3_id = p.Id
		break;

sec = client.service.GetSections(facility3_id)
#print sec
for  p in sec.Section:
	 if p.Name==SeactionName:
		SectionN = p
		break;

if SectionN.AppointmentTypes==None:
	AppType=client.factory.create('ns0:AppointmentType')
	AppointTypeCat = client.service.GetAppointmentTypeCategories(facility1_site_id)

	for p in AppointTypeCat.AppointmentTypeCategory:
		if p.Name=='REGULAR':
		   Cat=p
		   break;	
	AppType.Name='INITIAL'		
	AppType.AppointmentTypeCategory=Cat
	PatInstructions=client.factory.create('ns0:ArrayOfPatientInstructions')
	AppType.PatientInstructions=PatInstructions

	AppTypes=client.factory.create('ns0:ArrayOfAppointmentType')
	AppTypes.AppointmentType=AppType
	SectionN.AppointmentTypes=AppTypes

client.service.UpdateSection(SectionN)

AppointTypeCat = client.service.GetAppointmentTypeCategories(facility1_site_id)

for p in AppointTypeCat.AppointmentTypeCategory:
	if p.Name=='REGULAR':
	   Cat=p
	   break;

res = client.service.GetAllResourcesOfType(SectionN.Id,'Provider')

for p in res.Resource:
	if p.Name==ProviderResource:
		resprov=p
		break;
#print resprov

#-------------------Policy---------------------------------------------------------
schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resprov.SchedulingPolicies = schPolicies


RSlots = client.factory.create('ns0:ArrayOfSlot')
RSlot = client.factory.create('ns0:Slot')
RSlot.Time = 'PT18H'
RSlot.Length = 30
RSlot.Capacity = 1
RSlot.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot)
#---

RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT19H30M'
RSlot2.Length = 30
RSlot2.Capacity = 1
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
Result = client.service.UpdateResource(resprov)

#rr = client.service.GetResource(86)
#print rr

#raw_input()

	
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov
tzinfo=pytz.utc
appointment.Patient = pat
appointment.Length = 30
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,21,21,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'


#print appTimeStamp

MakeAppt = client.service.CreateWalkInAppointment(appointment)
#print MakeAppt

SchedTime = MakeAppt.Time

#print SchedTime

print 'Step 4 Display and view provider schedule' +'\n'
AppTimeFrom = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
AppTimeTo = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day+1)



TheAppoint = client.service.GetAppointmentsForPatient(pat.Id,AppTimeFrom,AppTimeTo)
for p in TheAppoint.Appointment:
	if p.Time==SchedTime:
		TheTime=p
		break;
print TheTime

print 'checkpoint 1'
if logdetail == 1:
	print MakeAppt
print 'verified patient walkin appointment'

print 'Step 5 Display and view patient check-in status'+'\n'
print TheTime.Status

print 'checkpoint 2'
if logdetail == 1:
	print TheTime.Status
print 'verified patient checkin status'

print 'Step 6 Checkout patient appointment'+'\n'

CheckO = client.service.GetAppointmentsForPatient(pat.Id,AppTimeFrom,AppTimeTo)
for p in CheckO.Appointment:
	if p.Time==SchedTime:
		Appt=p
		break;
print Appt.Status

Checkout = client.service.CheckOutAppointment(Appt.Id)
#print Checkout

print 'Step 7 Display other scheduled appointments'

AppTimeFrom1 = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
AppTimeTo1 = datetime.datetime(appTimeStamp.year,appTimeStamp.month+3,appTimeStamp.day)

OtherSched = client.service.GetAppointmentsForPatient(pat.Id,AppTimeFrom1,AppTimeTo1)
for p in OtherSched.Appointment:
	print p



























